/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.components.ForgePlayerOriginComponent;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.power.ActionOnBlockBreakPower;
import io.github.apace100.origins.power.ModifyBreakSpeedPower;
import io.github.apace100.origins.power.ModifyDamageDealtPower;
import io.github.apace100.origins.power.ModifyDamageTakenPower;
import io.github.apace100.origins.power.ModifyJumpPower;
import io.github.apace100.origins.power.ModifyProjectileDamagePower;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.forge.ModComponentsArchitecturyImpl;
import io.netty.buffer.Unpooled;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="origins")
public class OriginForgeEventHandler {
    @SubscribeEvent
    public static void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        float hardness = event.getState().func_185887_b((IBlockReader)player.field_70170_p, event.getPos());
        if (hardness <= 0.0f) {
            return;
        }
        float speed = event.getNewSpeed();
        if (PowerTypes.AQUA_AFFINITY.isActive((Entity)player)) {
            if (player.func_208600_a((ITag)FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i((LivingEntity)player)) {
                speed *= 5.0f;
            }
            if (!player.func_233570_aj_() && player.func_203005_aq()) {
                speed *= 5.0f;
            }
        }
        int toolFactor = ForgeHooks.canHarvestBlock((BlockState)event.getState(), (PlayerEntity)event.getPlayer(), (IBlockReader)event.getPlayer().field_70170_p, (BlockPos)event.getPos()) ? 30 : 100;
        float factor = hardness * (float)toolFactor;
        speed = OriginComponent.modify((Entity)player, ModifyBreakSpeedPower.class, speed * factor, p -> p.doesApply((IWorldReader)player.field_70170_p, event.getPos())) / factor;
        event.setNewSpeed(speed);
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            CachedBlockInfo cachedBlockPosition = new CachedBlockInfo((IWorldReader)event.getWorld(), event.getPos(), true);
            OriginComponent.getPowers((Entity)event.getPlayer(), ActionOnBlockBreakPower.class).stream().filter(p -> p.doesApply(cachedBlockPosition)).forEach(aobbp -> aobbp.executeActions(!event.isCanceled(), event.getPos(), null));
        }
    }

    @SubscribeEvent
    public static void modifyDamageTaken(LivingDamageEvent event) {
        LivingEntity entityLiving = event.getEntityLiving();
        event.setAmount(OriginComponent.modify((Entity)entityLiving, ModifyDamageTakenPower.class, event.getAmount(), p -> p.doesApply(event.getSource(), event.getAmount()), p -> p.executeActions(event.getSource().func_76346_g())));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void livingJump(LivingEvent.LivingJumpEvent event) {
        double modified = OriginComponent.modify((Entity)event.getEntityLiving(), ModifyJumpPower.class, event.getEntityLiving().func_213322_ci().field_72448_b, p -> true, ModifyJumpPower::executeAction);
        OriginForgeEventHandler.updateJumpHeight(modified, event.getEntityLiving());
    }

    private static void updateJumpHeight(double height, LivingEntity entity) {
        Vector3d vel = entity.func_213322_ci();
        double delta = height - vel.field_72448_b;
        if (delta == 0.0) {
            return;
        }
        entity.func_213317_d(vel.func_72441_c(0.0, delta, 0.0));
    }

    @SubscribeEvent
    public static void modifyDamageDealt(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (event.getSource().func_76352_a()) {
            event.setAmount(OriginComponent.modify(source.func_76346_g(), ModifyProjectileDamagePower.class, event.getAmount(), p -> p.doesApply(source, event.getAmount(), target), p -> p.executeActions((Entity)target)));
        } else {
            event.setAmount(OriginComponent.modify(source.func_76346_g(), ModifyDamageDealtPower.class, event.getAmount(), p -> p.doesApply(source, event.getAmount(), target), p -> p.executeActions((Entity)target)));
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(Origins.identifier("origin_component"), (ICapabilityProvider)new ForgePlayerOriginComponent((PlayerEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER) {
            ModComponentsArchitectury.getOriginComponent((Entity)event.player).serverTick();
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        OriginForgeEventHandler.copy(ModComponentsArchitecturyImpl.ORIGIN_COMPONENT_CAPABILITY, event);
    }

    @SubscribeEvent
    public static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ModComponentsArchitectury.syncWith((ServerPlayerEntity)event.getPlayer(), (Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ModComponentsArchitectury.syncWith((ServerPlayerEntity)event.getPlayer(), (Entity)event.getPlayer());
            OriginForgeEventHandler.checkOrigins((ServerPlayerEntity)event.getPlayer());
        }
    }

    private static void checkOrigins(ServerPlayerEntity entity) {
        OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)entity);
        if (!component.hasAllOrigins()) {
            PacketBuffer data = new PacketBuffer(Unpooled.buffer());
            data.writeBoolean(true);
            NetworkManager.sendToPlayer((ServerPlayerEntity)entity, (ResourceLocation)ModPackets.OPEN_ORIGIN_SCREEN, (PacketBuffer)data);
        }
    }

    @SubscribeEvent
    public static void trackNew(EntityJoinWorldEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        Entity entity = event.getEntity();
        IPacket<?> packet = ModComponentsArchitecturyImpl.buildOtherPacket(entity);
        if (packet != null) {
            PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((EntityJoinWorldEvent)event).getEntity()).send(packet);
        }
        if (entity instanceof ServerPlayerEntity) {
            OriginForgeEventHandler.checkOrigins((ServerPlayerEntity)entity);
        }
    }

    @SubscribeEvent
    public static void trackEntity(PlayerEvent.StartTracking event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && event.getTarget() instanceof PlayerEntity) {
            ModComponentsArchitectury.syncWith((ServerPlayerEntity)event.getPlayer(), event.getTarget());
        }
    }

    public static <T> void copy(Capability<T> cap, PlayerEvent.Clone event) {
        event.getPlayer().getCapability(cap).ifPresent(target -> event.getOriginal().getCapability(cap).ifPresent(source -> cap.readNBT(target, null, cap.writeNBT(source, null))));
    }
}

